import os

def remove_duplicates_by_name(src_folder, target_folder):
    """Remove files in src_folder that have the same name as files in target_folder."""
    target_files_names = set(os.listdir(target_folder))
    
    for filename in os.listdir(src_folder):
        if filename in target_files_names:
            file_path = os.path.join(src_folder, filename)
            os.remove(file_path)
            print(f"Removed duplicate file: {file_path}")

# Replace these paths with the correct paths to your folders
artificial_folder_path = "artificial"
tv_folder_path = "tv"

remove_duplicates_by_name(artificial_folder_path, tv_folder_path)

